import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sns

atp_tennis = pd.read_csv('atp_tennis.csv')

# Bar Chart for Surface Types
fig3, ax3 = plt.subplots()
surface_counts = atp_tennis['Surface'].value_counts()
surface_counts.plot.bar(ax=ax3)
ax3.set_title('Matches by Surface Type')
ax3.set_xlabel('Surface')
ax3.set_ylabel('Number of Matches')
plt.savefig('./ref_result/bar_chart.png')
plt.show()
